/*
 * milena_keychar.c - Milena TTS system (spd helper)
 * Copyright (C) Bohdan R. Rau 2010 <ethanak@polip.com>
 * 
 * Milena is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * Milena is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with Milena.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

static char *_milena_ascii_chars[]={
"spacja","wykrzyknik","cudzysw","hasz","dolar","procent","and","apostrof",
"nawias","po nawiasie","gwiazdka","plus","przecinek","mylnik","kropka","ukonik",
"zero","jeden","dwa","trzy","cztery","pi","sze","siedem",
"osiem","dziewi","dwukropek","rednik","mniejsze","rwne","wiksze","znak zapytania",
"mapa","a","be","ce","de","e","ef","gie","ha","i","jot","ka","el","em","en","o",
"pe","qu","er","es","te","u","fa","vu","iks","igrek","zet","nawias kwadratowy","bekslesz","prawy nawias kwadratowy","daszek","podkrelnik",
"akcent","a","be","ce","de","e","ef","gie","ha","i","jot","ka","el","em","en","o",
"pe","qu","er","es","te","u","fa","vu","iks","igrek","zet","klamra","pipa","po klamrze","tylda"};


static char *_milena_get_char_desc(struct milena *cfg,char *c,char *def)
{
	struct milena_key *kl;
	for (kl=cfg->chardes;kl;kl=kl->next) if (!strcmp(kl->key,c)) return kl->pron;
	if (def) return def;
	return c;
}

int milena_ReadKeyChar(struct milena *cfg,char *fname)
{
	FILE *f;char buf[256];
	struct milena_key *kl,**kkl;
	struct milena_char *cl;
	int mode,chr;
	kkl=NULL;
	mode=0;
	f=fopen(fname,"r");
	if (!f) {
		perror(fname);
		return 0;
	}
	while (fgets(buf,256,f)) {
		char *c=buf,*d,*e;
		while (*c && isspace(*c)) c++;
		if (!*c) continue;
		if (*c=='[' && islower(c[1])) {
			switch (c[1]) {
				case 'k':mode=1;kkl=&cfg->keys;break;
				case 'd':mode=1;kkl=&cfg->chardes;break;
				case 'c':mode=2;break;
				default: mode=0;
			}
			continue;
		}
		if (!mode) continue;
			
		d=c;
		while (*d && !isspace(*d)) d++;
		if (!*d) continue;
		*d++=0;
		while (*d && isspace(*d)) d++;
		if (!*d) continue;
		if (mode == 1) {
			kl=qalloc(sizeof(*kl));
			kl->key=strdup(c);
			for (e=c=d;*c;c++) if (!isspace(*c)) e=c+1;
			*e=0;
			kl->pron=strdup(d);
			kl->next=*kkl;
			*kkl=kl;
		}
		else {
			if (!c[1]) chr=c[0];
			else if (c[0]=='x') chr=strtol(c+1,NULL,16);
			else chr=strtol(c,NULL,10);
			for (e=c=d;*c;c++) if (!isspace(*c)) e=c+1;
			*e=0;
			cl=qalloc(sizeof(*cl));
			cl->chr=chr;
			cl->pron=strdup(d);
			cl->next=cfg->charnms;
			cfg->charnms=cl;
		}
	}
	fclose(f);
	return 1;
}

/* skrt */

static struct {
	unsigned short flags;
	char letter;
	char second;
} char_descr[]={
{8,'a',0},{3,'a',0},{6,'a',0},{14,'a',0},{7,'a',0},{12,'a',0},{1,'a','e'},{5,'c',0},
{8,'e',0},{3,'e',0},{6,'e',0},{7,'e',0},{8,'i',0},{3,'i',0},{6,'i',0},{7,'i',0},
{0,0,0},{14,'n',0},{8,'o',0},{3,'o',0},{6,'o',0},{14,'o',0},{7,'o',0},{0,0,0},
{13,'o',0},{8,'u',0},{3,'u',0},{6,'u',0},{7,'u',0},{3,'y',0},{0,0,0},{0,0,0},
{8,'a',0},{3,'a',0},{6,'a',0},{14,'a',0},{7,'a',0},{12,'a',0},{1,'a','e'},{5,'c',0},
{8,'e',0},{3,'e',0},{6,'e',0},{7,'e',0},{8,'i',0},{3,'i',0},{6,'i',0},{7,'i',0},
{0,0,0},{14,'n',0},{8,'o',0},{3,'o',0},{6,'o',0},{14,'o',0},{7,'o',0},{0,0,0},
{13,'o',0},{8,'u',0},{3,'u',0},{6,'u',0},{7,'u',0},{3,'y',0},{0,0,0},{7,'y',0},
{10,'a',0},{10,'a',0},{4,'a',0},{4,'a',0},{11,'a',0},{11,'a',0},{3,'c',0},{3,'c',0},
{6,'c',0},{6,'c',0},{15,'c',0},{15,'c',0},{9,'c',0},{9,'c',0},{9,'d',0},{9,'d',0},
{13,'d',0},{13,'d',0},{10,'e',0},{10,'e',0},{4,'e',0},{4,'e',0},{15,'e',0},{15,'e',0},
{11,'e',0},{11,'e',0},{9,'e',0},{9,'e',0},{6,'g',0},{6,'g',0},{4,'g',0},{4,'g',0},
{15,'g',0},{15,'g',0},{5,'g',0},{5,'g',0},{6,'h',0},{6,'h',0},{13,'h',0},{13,'h',0},
{14,'i',0},{14,'i',0},{10,'i',0},{10,'i',0},{4,'i',0},{4,'i',0},{11,'i',0},{11,'i',0},
{15,'i',0},{0,0,0},{1,'i','j'},{1,'i','j'},{6,'j',0},{6,'j',0},{5,'k',0},{5,'k',0},
{0,0,0},{3,'l',0},{3,'l',0},{5,'l',0},{5,'l',0},{9,'l',0},{9,'l',0},{16,'l',0},
{16,'l',0},{13,'l',0},{13,'l',0},{3,'n',0},{3,'n',0},{5,'n',0},{5,'n',0},{9,'n',0},
{9,'n',0},{0,0,0},{0,0,0},{0,0,0},{10,'o',0},{10,'o',0},{4,'o',0},{4,'o',0},
{2,'o',0},{2,'o',0},{1,'o','e'},{1,'o','e'},{3,'r',0},{3,'r',0},{5,'r',0},{5,'r',0},
{9,'r',0},{9,'r',0},{3,'s',0},{3,'s',0},{6,'s',0},{6,'s',0},{5,'s',0},{5,'s',0},
{9,'s',0},{9,'s',0},{5,'t',0},{5,'t',0},{9,'t',0},{9,'t',0},{13,'t',0},{13,'t',0},
{14,'u',0},{14,'u',0},{10,'u',0},{10,'u',0},{4,'u',0},{4,'u',0},{12,'u',0},{12,'u',0},
{2,'u',0},{2,'u',0},{11,'u',0},{11,'u',0},{6,'w',0},{6,'w',0},{6,'y',0},{6,'y',0},
{7,'y',0},{3,'z',0},{3,'z',0},{15,'z',0},{15,'z',0},{9,'z',0},{9,'z',0},{0,0,0}};

#define MILENA_MAX_CHAR_DEFINED (0xc0 + sizeof(char_descr)/sizeof(char_descr[0]))

static char *dia_sym[15]={"ac2","acu","bre","ced","cir","dia","gra","car",
		   "mac","ogo","rin","str","til","dot","mdo"};

/* fctype - simplified, locale independent wctype functions */

#define U_LETTER 1
#define U_UPPER 2
#define U_DIGIT 4
#define U_SPACE 8
#define U_PRINT 16

static unsigned char letter_flags[0x1000]={
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
24,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
20,20,20,20,20,20,20,20,20,20,16,16,16,16,16,16,
16,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,19,19,16,16,16,16,16,
16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
24,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,17,16,16,16,16,16,16,16,16,16,16,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,16,19,19,19,19,19,19,19,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,16,17,17,17,17,17,17,17,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,17,19,17,19,17,19,17,19,
17,19,17,19,17,19,17,19,17,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,19,19,17,19,17,19,17,17,
17,19,19,17,19,17,19,19,17,19,19,19,17,17,19,19,
19,19,17,19,19,17,19,19,19,17,17,17,19,19,17,19,
19,17,19,17,19,17,19,19,17,19,17,17,19,17,19,19,
17,19,19,19,17,19,17,19,19,17,17,17,19,17,17,17,
17,17,17,17,19,17,17,19,17,17,19,17,17,19,17,19,
17,19,17,19,17,19,17,19,17,19,17,19,17,17,19,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
17,19,17,17,19,17,8,8,8,8,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,8,8,8,8,8,8,8,
17,17,17,17,17,17,17,17,17,16,16,17,17,17,17,17,
17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
17,17,16,16,16,16,16,16,16,16,16,16,16,16,16,8,
17,17,17,17,17,16,16,16,16,16,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
16,16,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,16,16,8,8,8,8,17,8,8,8,16,8,
8,8,8,8,16,16,19,16,19,19,19,8,19,8,19,19,
17,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,8,19,19,19,19,19,19,19,19,19,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,8,
17,17,19,19,19,17,17,8,8,8,19,8,19,8,19,8,
19,8,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
17,17,17,17,8,8,8,8,8,8,8,8,8,8,8,8,
8,19,19,19,19,19,19,19,19,19,19,19,19,8,19,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
8,17,17,17,17,17,17,17,17,17,17,17,17,8,17,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,16,16,16,16,16,8,8,8,8,8,8,8,8,8,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
17,19,17,19,17,8,8,19,17,8,8,19,17,8,8,8,
19,17,19,17,19,17,19,17,19,17,19,17,19,17,19,17,
19,17,19,17,19,17,19,17,19,17,19,17,8,8,19,17,
19,17,19,17,19,17,8,8,19,17,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,8,8,17,16,16,16,16,16,16,
8,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,8,16,8,8,8,8,8,8,
8,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,8,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,8,16,16,16,16,16,
16,16,16,16,16,8,8,8,8,8,8,8,8,8,8,8,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,8,8,8,8,8,
17,17,17,16,16,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,16,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,16,8,8,8,16,
8,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,8,8,8,8,8,
17,17,17,17,17,17,17,17,17,17,17,16,16,16,16,16,
16,16,16,8,8,8,8,8,8,8,8,8,8,8,8,8,
20,20,20,20,20,20,20,20,20,20,16,16,16,16,8,8,
16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,8,8,17,17,17,17,17,8,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,8,
17,17,17,17,16,17,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,17,17,16,16,16,16,16,16,16,8,8,
20,20,20,20,20,20,20,20,20,20,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,16,16,16,8,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,8,8,16,17,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,8,8,
17,16,16,16,16,8,8,8,17,17,17,17,17,17,17,17,
17,17,16,16,16,16,20,20,20,20,20,20,20,20,20,20,
16,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,16,16,16,8,17,17,17,17,17,17,17,17,8,8,17,
17,8,8,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,8,17,17,17,17,17,17,
17,8,17,8,8,8,17,17,17,17,8,8,16,8,16,16,
16,16,16,16,16,8,8,16,16,8,8,16,16,16,8,8,
8,8,8,8,8,8,8,16,8,8,8,8,17,17,8,17,
17,17,16,16,8,8,20,20,20,20,20,20,20,20,20,20,
17,17,16,16,16,16,16,16,16,16,16,8,8,8,8,8,
8,8,16,8,8,17,17,17,17,17,17,8,8,8,8,17,
17,8,8,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,8,17,17,17,17,17,17,
17,8,17,17,8,17,17,8,17,17,8,8,16,8,16,16,
16,16,16,8,8,8,8,16,16,8,8,16,16,16,8,8,
8,8,8,8,8,8,8,8,8,17,17,17,17,8,17,8,
8,8,8,8,8,8,20,20,20,20,20,20,20,20,20,20,
16,16,17,17,17,8,8,8,8,8,8,8,8,8,8,8,
8,16,16,16,8,17,17,17,17,17,17,17,8,17,8,17,
17,17,8,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,8,17,17,17,17,17,17,
17,8,17,17,8,17,17,17,17,17,8,8,16,17,16,16,
16,16,16,16,16,16,8,16,16,16,8,16,16,16,8,8,
17,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
17,8,8,8,8,8,20,20,20,20,20,20,20,20,20,20,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,16,16,16,8,17,17,17,17,17,17,17,17,8,8,17,
17,8,8,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,8,17,17,17,17,17,17,
17,8,17,17,8,8,17,17,17,17,8,8,16,17,16,16,
16,16,16,16,8,8,8,16,16,8,8,16,16,16,8,8,
8,8,8,8,8,8,16,16,8,8,8,8,17,17,8,17,
17,17,8,8,8,8,20,20,20,20,20,20,20,20,20,20,
16,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,16,16,8,17,17,17,17,17,17,8,8,8,17,17,
17,8,17,17,17,17,8,8,8,17,17,8,17,8,17,17,
8,8,8,17,17,8,8,8,17,17,17,8,8,8,17,17,
17,17,17,17,17,17,8,17,17,17,8,8,8,8,16,16,
16,16,16,8,8,8,16,16,16,8,16,16,16,16,8,8,
8,8,8,8,8,8,8,16,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,20,20,20,20,20,20,20,20,20,
16,16,16,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,16,16,16,8,17,17,17,17,17,17,17,17,8,17,17,
17,8,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,8,17,17,17,17,17,17,
17,17,17,17,8,17,17,17,17,17,8,8,8,8,16,16,
16,16,16,16,16,8,16,16,16,8,16,16,16,16,8,8,
8,8,8,8,8,16,16,8,8,8,8,8,8,8,8,8,
17,17,8,8,8,8,20,20,20,20,20,20,20,20,20,20,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,16,16,8,17,17,17,17,17,17,17,17,8,17,17,
17,8,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,8,17,17,17,17,17,17,
17,17,17,17,8,17,17,17,17,17,8,8,8,8,16,16,
16,16,16,16,16,8,16,16,16,8,16,16,16,16,8,8,
8,8,8,8,8,16,16,8,8,8,8,8,8,8,17,8,
17,17,8,8,8,8,20,20,20,20,20,20,20,20,20,20,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,16,16,8,17,17,17,17,17,17,17,17,8,17,17,
17,8,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,8,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,8,8,8,8,16,16,
16,16,16,16,8,8,16,16,16,8,16,16,16,16,8,8,
8,8,8,8,8,8,8,16,8,8,8,8,8,8,8,8,
17,17,8,8,8,8,20,20,20,20,20,20,20,20,20,20,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,16,17,17,16,16,16,16,16,16,16,8,8,8,8,16,
17,17,17,17,17,17,17,16,16,16,16,16,16,16,16,16,
20,20,20,20,20,20,20,20,20,20,16,16,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,17,17,8,17,8,8,17,17,8,17,8,8,17,8,8,
8,8,8,8,17,17,17,17,8,17,17,17,17,17,17,17,
8,17,17,17,8,17,8,17,8,8,17,17,8,17,17,17,
17,16,17,17,16,16,16,16,16,16,8,16,16,17,8,8,
17,17,17,17,17,8,17,8,16,16,16,16,16,16,8,8,
20,20,20,20,20,20,20,20,20,20,8,8,17,17,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
17,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
20,20,20,20,20,20,20,20,20,20,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
17,17,17,17,17,17,17,17,8,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,8,8,8,8,8,8,
8,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,17,17,17,17,8,8,8,8,
16,16,16,16,16,16,8,16,8,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,8,8,
8,16,16,16,16,16,16,16,8,16,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8};

static unsigned short letter_lower[0x1000]={
0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,
48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
64,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
112,113,114,115,116,117,118,119,120,121,122,91,92,93,94,95,
96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,
112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,
128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,
176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,
224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
240,241,242,243,244,245,246,215,248,249,250,251,252,253,254,223,
224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,
257,257,259,259,261,261,263,263,265,265,267,267,269,269,271,271,
273,273,275,275,277,277,279,279,281,281,283,283,285,285,287,287,
289,289,291,291,293,293,295,295,297,297,299,299,301,301,303,303,
105,305,307,307,309,309,311,311,312,314,314,316,316,318,318,320,
320,322,322,324,324,326,326,328,328,329,331,331,333,333,335,335,
337,337,339,339,341,341,343,343,345,345,347,347,349,349,351,351,
353,353,355,355,357,357,359,359,361,361,363,363,365,365,367,367,
369,369,371,371,373,373,375,375,255,378,378,380,380,382,382,383,
384,595,387,387,389,389,596,392,392,598,599,396,396,397,477,601,
603,402,402,608,611,405,617,616,409,409,410,411,623,626,414,629,
417,417,419,419,421,421,640,424,424,643,426,427,429,429,648,432,
432,650,651,436,436,438,438,658,441,441,442,443,445,445,446,447,
448,449,450,451,454,454,454,457,457,457,460,460,460,462,462,464,
464,466,466,468,468,470,470,472,472,474,474,476,476,477,479,479,
481,481,483,483,485,485,487,487,489,489,491,491,493,493,495,495,
496,499,499,499,501,501,502,503,504,505,507,507,509,509,511,511,
513,513,515,515,517,517,519,519,521,521,523,523,525,525,527,527,
529,529,531,531,533,533,535,535,536,537,538,539,540,541,542,543,
544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559,
560,561,562,563,564,565,566,567,568,569,570,571,572,573,574,575,
576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,
592,593,594,595,596,597,598,599,600,601,602,603,604,605,606,607,
608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,
624,625,626,627,628,629,630,631,632,633,634,635,636,637,638,639,
640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,
656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,
672,673,674,675,676,677,678,679,680,681,682,683,684,685,686,687,
688,689,690,691,692,693,694,695,696,697,698,699,700,701,702,703,
704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,
720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,735,
736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,
752,753,754,755,756,757,758,759,760,761,762,763,764,765,766,767,
768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,
784,785,786,787,788,789,790,791,792,793,794,795,796,797,798,799,
800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,
816,817,818,819,820,821,822,823,824,825,826,827,828,829,830,831,
832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,
848,849,850,851,852,853,854,855,856,857,858,859,860,861,862,863,
864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,
880,881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,
896,897,898,899,900,901,940,903,941,942,943,907,972,909,973,974,
912,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,
960,961,930,963,964,965,966,967,968,969,970,971,940,941,942,943,
944,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,
960,961,962,963,964,965,966,967,968,969,970,971,972,973,974,975,
976,977,0,0,0,981,982,983,984,985,0,987,0,989,0,991,
0,993,995,995,997,997,999,999,1001,1001,1003,1003,1005,1005,1007,1007,
1008,1009,1010,1011,1012,1013,1014,1015,1016,1017,1018,1019,1020,1021,1022,1023,
1024,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1037,1118,1119,
1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,
1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,
1072,1073,1074,1075,1076,1077,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,
1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,
1104,1105,1106,1107,1108,1109,1110,1111,1112,1113,1114,1115,1116,1117,1118,1119,
1121,1121,1123,1123,1125,1125,1127,1127,1129,1129,1131,1131,1133,1133,1135,1135,
1137,1137,1139,1139,1141,1141,1143,1143,1145,1145,1147,1147,1149,1149,1151,1151,
1153,1153,1154,1155,1156,1157,1158,1159,1160,1161,1162,1163,1164,1165,1166,1167,
1169,1169,1171,1171,1173,1173,1175,1175,1177,1177,1179,1179,1181,1181,1183,1183,
1185,1185,1187,1187,1189,1189,1191,1191,1193,1193,1195,1195,1197,1197,1199,1199,
1201,1201,1203,1203,1205,1205,1207,1207,1209,1209,1211,1211,1213,1213,1215,1215,
1216,1218,1218,1220,1220,1221,1222,1224,1224,1225,1226,1228,1228,1229,1230,1231,
1233,1233,1235,1235,1237,1237,1239,1239,1241,1241,1243,1243,1245,1245,1247,1247,
1249,1249,1251,1251,1253,1253,1255,1255,1257,1257,1259,1259,1260,1261,1263,1263,
1265,1265,1267,1267,1269,1269,1270,1271,1273,1273,1274,1275,1276,1277,1278,1279,
1280,1281,1282,1283,1284,1285,1286,1287,1288,1289,1290,1291,1292,1293,1294,1295,
1296,1297,1298,1299,1300,1301,1302,1303,1304,1305,1306,1307,1308,1309,1310,1311,
1312,1313,1314,1315,1316,1317,1318,1319,1320,1321,1322,1323,1324,1325,1326,1327,
1328,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,
1392,1393,1394,1395,1396,1397,1398,1399,1400,1401,1402,1403,1404,1405,1406,1407,
1408,1409,1410,1411,1412,1413,1414,1367,1368,1369,1370,1371,1372,1373,1374,1375,
1376,1377,1378,1379,1380,1381,1382,1383,1384,1385,1386,1387,1388,1389,1390,1391,
1392,1393,1394,1395,1396,1397,1398,1399,1400,1401,1402,1403,1404,1405,1406,1407,
1408,1409,1410,1411,1412,1413,1414,1415,1416,1417,1418,1419,1420,1421,1422,1423,
1424,1425,1426,1427,1428,1429,1430,1431,1432,1433,1434,1435,1436,1437,1438,1439,
1440,1441,1442,1443,1444,1445,1446,1447,1448,1449,1450,1451,1452,1453,1454,1455,
1456,1457,1458,1459,1460,1461,1462,1463,1464,1465,1466,1467,1468,1469,1470,1471,
1472,1473,1474,1475,1476,1477,1478,1479,1480,1481,1482,1483,1484,1485,1486,1487,
1488,1489,1490,1491,1492,1493,1494,1495,1496,1497,1498,1499,1500,1501,1502,1503,
1504,1505,1506,1507,1508,1509,1510,1511,1512,1513,1514,1515,1516,1517,1518,1519,
1520,1521,1522,1523,1524,1525,1526,1527,1528,1529,1530,1531,1532,1533,1534,1535,
1536,1537,1538,1539,1540,1541,1542,1543,1544,1545,1546,1547,1548,1549,1550,1551,
1552,1553,1554,1555,1556,1557,1558,1559,1560,1561,1562,1563,1564,1565,1566,1567,
1568,1569,1570,1571,1572,1573,1574,1575,1576,1577,1578,1579,1580,1581,1582,1583,
1584,1585,1586,1587,1588,1589,1590,1591,1592,1593,1594,1595,1596,1597,1598,1599,
1600,1601,1602,1603,1604,1605,1606,1607,1608,1609,1610,1611,1612,1613,1614,1615,
1616,1617,1618,1619,1620,1621,1622,1623,1624,1625,1626,1627,1628,1629,1630,1631,
1632,1633,1634,1635,1636,1637,1638,1639,1640,1641,1642,1643,1644,1645,1646,1647,
1648,1649,1650,1651,1652,1653,1654,1655,1656,1657,1658,1659,1660,1661,1662,1663,
1664,1665,1666,1667,1668,1669,1670,1671,1672,1673,1674,1675,1676,1677,1678,1679,
1680,1681,1682,1683,1684,1685,1686,1687,1688,1689,1690,1691,1692,1693,1694,1695,
1696,1697,1698,1699,1700,1701,1702,1703,1704,1705,1706,1707,1708,1709,1710,1711,
1712,1713,1714,1715,1716,1717,1718,1719,1720,1721,1722,1723,1724,1725,1726,1727,
1728,1729,1730,1731,1732,1733,1734,1735,1736,1737,1738,1739,1740,1741,1742,1743,
1744,1745,1746,1747,1748,1749,1750,1751,1752,1753,1754,1755,1756,1757,1758,1759,
1760,1761,1762,1763,1764,1765,1766,1767,1768,1769,1770,1771,1772,1773,1774,1775,
1776,1777,1778,1779,1780,1781,1782,1783,1784,1785,1786,1787,1788,1789,1790,1791,
1792,1793,1794,1795,1796,1797,1798,1799,1800,1801,1802,1803,1804,1805,1806,1807,
1808,1809,1810,1811,1812,1813,1814,1815,1816,1817,1818,1819,1820,1821,1822,1823,
1824,1825,1826,1827,1828,1829,1830,1831,1832,1833,1834,1835,1836,1837,1838,1839,
1840,1841,1842,1843,1844,1845,1846,1847,1848,1849,1850,1851,1852,1853,1854,1855,
1856,1857,1858,1859,1860,1861,1862,1863,1864,1865,1866,1867,1868,1869,1870,1871,
1872,1873,1874,1875,1876,1877,1878,1879,1880,1881,1882,1883,1884,1885,1886,1887,
1888,1889,1890,1891,1892,1893,1894,1895,1896,1897,1898,1899,1900,1901,1902,1903,
1904,1905,1906,1907,1908,1909,1910,1911,1912,1913,1914,1915,1916,1917,1918,1919,
1920,1921,1922,1923,1924,1925,1926,1927,1928,1929,1930,1931,1932,1933,1934,1935,
1936,1937,1938,1939,1940,1941,1942,1943,1944,1945,1946,1947,1948,1949,1950,1951,
1952,1953,1954,1955,1956,1957,1958,1959,1960,1961,1962,1963,1964,1965,1966,1967,
1968,1969,1970,1971,1972,1973,1974,1975,1976,1977,1978,1979,1980,1981,1982,1983,
1984,1985,1986,1987,1988,1989,1990,1991,1992,1993,1994,1995,1996,1997,1998,1999,
2000,2001,2002,2003,2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014,2015,
2016,2017,2018,2019,2020,2021,2022,2023,2024,2025,2026,2027,2028,2029,2030,2031,
2032,2033,2034,2035,2036,2037,2038,2039,2040,2041,2042,2043,2044,2045,2046,2047,
2048,2049,2050,2051,2052,2053,2054,2055,2056,2057,2058,2059,2060,2061,2062,2063,
2064,2065,2066,2067,2068,2069,2070,2071,2072,2073,2074,2075,2076,2077,2078,2079,
2080,2081,2082,2083,2084,2085,2086,2087,2088,2089,2090,2091,2092,2093,2094,2095,
2096,2097,2098,2099,2100,2101,2102,2103,2104,2105,2106,2107,2108,2109,2110,2111,
2112,2113,2114,2115,2116,2117,2118,2119,2120,2121,2122,2123,2124,2125,2126,2127,
2128,2129,2130,2131,2132,2133,2134,2135,2136,2137,2138,2139,2140,2141,2142,2143,
2144,2145,2146,2147,2148,2149,2150,2151,2152,2153,2154,2155,2156,2157,2158,2159,
2160,2161,2162,2163,2164,2165,2166,2167,2168,2169,2170,2171,2172,2173,2174,2175,
2176,2177,2178,2179,2180,2181,2182,2183,2184,2185,2186,2187,2188,2189,2190,2191,
2192,2193,2194,2195,2196,2197,2198,2199,2200,2201,2202,2203,2204,2205,2206,2207,
2208,2209,2210,2211,2212,2213,2214,2215,2216,2217,2218,2219,2220,2221,2222,2223,
2224,2225,2226,2227,2228,2229,2230,2231,2232,2233,2234,2235,2236,2237,2238,2239,
2240,2241,2242,2243,2244,2245,2246,2247,2248,2249,2250,2251,2252,2253,2254,2255,
2256,2257,2258,2259,2260,2261,2262,2263,2264,2265,2266,2267,2268,2269,2270,2271,
2272,2273,2274,2275,2276,2277,2278,2279,2280,2281,2282,2283,2284,2285,2286,2287,
2288,2289,2290,2291,2292,2293,2294,2295,2296,2297,2298,2299,2300,2301,2302,2303,
2304,2305,2306,2307,2308,2309,2310,2311,2312,2313,2314,2315,2316,2317,2318,2319,
2320,2321,2322,2323,2324,2325,2326,2327,2328,2329,2330,2331,2332,2333,2334,2335,
2336,2337,2338,2339,2340,2341,2342,2343,2344,2345,2346,2347,2348,2349,2350,2351,
2352,2353,2354,2355,2356,2357,2358,2359,2360,2361,2362,2363,2364,2365,2366,2367,
2368,2369,2370,2371,2372,2373,2374,2375,2376,2377,2378,2379,2380,2381,2382,2383,
2384,2385,2386,2387,2388,2389,2390,2391,2392,2393,2394,2395,2396,2397,2398,2399,
2400,2401,2402,2403,2404,2405,2406,2407,2408,2409,2410,2411,2412,2413,2414,2415,
2416,2417,2418,2419,2420,2421,2422,2423,2424,2425,2426,2427,2428,2429,2430,2431,
2432,2433,2434,2435,2436,2437,2438,2439,2440,2441,2442,2443,2444,2445,2446,2447,
2448,2449,2450,2451,2452,2453,2454,2455,2456,2457,2458,2459,2460,2461,2462,2463,
2464,2465,2466,2467,2468,2469,2470,2471,2472,2473,2474,2475,2476,2477,2478,2479,
2480,2481,2482,2483,2484,2485,2486,2487,2488,2489,2490,2491,2492,2493,2494,2495,
2496,2497,2498,2499,2500,2501,2502,2503,2504,2505,2506,2507,2508,2509,2510,2511,
2512,2513,2514,2515,2516,2517,2518,2519,2520,2521,2522,2523,2524,2525,2526,2527,
2528,2529,2530,2531,2532,2533,2534,2535,2536,2537,2538,2539,2540,2541,2542,2543,
2544,2545,2546,2547,2548,2549,2550,2551,2552,2553,2554,2555,2556,2557,2558,2559,
2560,2561,2562,2563,2564,2565,2566,2567,2568,2569,2570,2571,2572,2573,2574,2575,
2576,2577,2578,2579,2580,2581,2582,2583,2584,2585,2586,2587,2588,2589,2590,2591,
2592,2593,2594,2595,2596,2597,2598,2599,2600,2601,2602,2603,2604,2605,2606,2607,
2608,2609,2610,2611,2612,2613,2614,2615,2616,2617,2618,2619,2620,2621,2622,2623,
2624,2625,2626,2627,2628,2629,2630,2631,2632,2633,2634,2635,2636,2637,2638,2639,
2640,2641,2642,2643,2644,2645,2646,2647,2648,2649,2650,2651,2652,2653,2654,2655,
2656,2657,2658,2659,2660,2661,2662,2663,2664,2665,2666,2667,2668,2669,2670,2671,
2672,2673,2674,2675,2676,2677,2678,2679,2680,2681,2682,2683,2684,2685,2686,2687,
2688,2689,2690,2691,2692,2693,2694,2695,2696,2697,2698,2699,2700,2701,2702,2703,
2704,2705,2706,2707,2708,2709,2710,2711,2712,2713,2714,2715,2716,2717,2718,2719,
2720,2721,2722,2723,2724,2725,2726,2727,2728,2729,2730,2731,2732,2733,2734,2735,
2736,2737,2738,2739,2740,2741,2742,2743,2744,2745,2746,2747,2748,2749,2750,2751,
2752,2753,2754,2755,2756,2757,2758,2759,2760,2761,2762,2763,2764,2765,2766,2767,
2768,2769,2770,2771,2772,2773,2774,2775,2776,2777,2778,2779,2780,2781,2782,2783,
2784,2785,2786,2787,2788,2789,2790,2791,2792,2793,2794,2795,2796,2797,2798,2799,
2800,2801,2802,2803,2804,2805,2806,2807,2808,2809,2810,2811,2812,2813,2814,2815,
2816,2817,2818,2819,2820,2821,2822,2823,2824,2825,2826,2827,2828,2829,2830,2831,
2832,2833,2834,2835,2836,2837,2838,2839,2840,2841,2842,2843,2844,2845,2846,2847,
2848,2849,2850,2851,2852,2853,2854,2855,2856,2857,2858,2859,2860,2861,2862,2863,
2864,2865,2866,2867,2868,2869,2870,2871,2872,2873,2874,2875,2876,2877,2878,2879,
2880,2881,2882,2883,2884,2885,2886,2887,2888,2889,2890,2891,2892,2893,2894,2895,
2896,2897,2898,2899,2900,2901,2902,2903,2904,2905,2906,2907,2908,2909,2910,2911,
2912,2913,2914,2915,2916,2917,2918,2919,2920,2921,2922,2923,2924,2925,2926,2927,
2928,2929,2930,2931,2932,2933,2934,2935,2936,2937,2938,2939,2940,2941,2942,2943,
2944,2945,2946,2947,2948,2949,2950,2951,2952,2953,2954,2955,2956,2957,2958,2959,
2960,2961,2962,2963,2964,2965,2966,2967,2968,2969,2970,2971,2972,2973,2974,2975,
2976,2977,2978,2979,2980,2981,2982,2983,2984,2985,2986,2987,2988,2989,2990,2991,
2992,2993,2994,2995,2996,2997,2998,2999,3000,3001,3002,3003,3004,3005,3006,3007,
3008,3009,3010,3011,3012,3013,3014,3015,3016,3017,3018,3019,3020,3021,3022,3023,
3024,3025,3026,3027,3028,3029,3030,3031,3032,3033,3034,3035,3036,3037,3038,3039,
3040,3041,3042,3043,3044,3045,3046,3047,3048,3049,3050,3051,3052,3053,3054,3055,
3056,3057,3058,3059,3060,3061,3062,3063,3064,3065,3066,3067,3068,3069,3070,3071,
3072,3073,3074,3075,3076,3077,3078,3079,3080,3081,3082,3083,3084,3085,3086,3087,
3088,3089,3090,3091,3092,3093,3094,3095,3096,3097,3098,3099,3100,3101,3102,3103,
3104,3105,3106,3107,3108,3109,3110,3111,3112,3113,3114,3115,3116,3117,3118,3119,
3120,3121,3122,3123,3124,3125,3126,3127,3128,3129,3130,3131,3132,3133,3134,3135,
3136,3137,3138,3139,3140,3141,3142,3143,3144,3145,3146,3147,3148,3149,3150,3151,
3152,3153,3154,3155,3156,3157,3158,3159,3160,3161,3162,3163,3164,3165,3166,3167,
3168,3169,3170,3171,3172,3173,3174,3175,3176,3177,3178,3179,3180,3181,3182,3183,
3184,3185,3186,3187,3188,3189,3190,3191,3192,3193,3194,3195,3196,3197,3198,3199,
3200,3201,3202,3203,3204,3205,3206,3207,3208,3209,3210,3211,3212,3213,3214,3215,
3216,3217,3218,3219,3220,3221,3222,3223,3224,3225,3226,3227,3228,3229,3230,3231,
3232,3233,3234,3235,3236,3237,3238,3239,3240,3241,3242,3243,3244,3245,3246,3247,
3248,3249,3250,3251,3252,3253,3254,3255,3256,3257,3258,3259,3260,3261,3262,3263,
3264,3265,3266,3267,3268,3269,3270,3271,3272,3273,3274,3275,3276,3277,3278,3279,
3280,3281,3282,3283,3284,3285,3286,3287,3288,3289,3290,3291,3292,3293,3294,3295,
3296,3297,3298,3299,3300,3301,3302,3303,3304,3305,3306,3307,3308,3309,3310,3311,
3312,3313,3314,3315,3316,3317,3318,3319,3320,3321,3322,3323,3324,3325,3326,3327,
3328,3329,3330,3331,3332,3333,3334,3335,3336,3337,3338,3339,3340,3341,3342,3343,
3344,3345,3346,3347,3348,3349,3350,3351,3352,3353,3354,3355,3356,3357,3358,3359,
3360,3361,3362,3363,3364,3365,3366,3367,3368,3369,3370,3371,3372,3373,3374,3375,
3376,3377,3378,3379,3380,3381,3382,3383,3384,3385,3386,3387,3388,3389,3390,3391,
3392,3393,3394,3395,3396,3397,3398,3399,3400,3401,3402,3403,3404,3405,3406,3407,
3408,3409,3410,3411,3412,3413,3414,3415,3416,3417,3418,3419,3420,3421,3422,3423,
3424,3425,3426,3427,3428,3429,3430,3431,3432,3433,3434,3435,3436,3437,3438,3439,
3440,3441,3442,3443,3444,3445,3446,3447,3448,3449,3450,3451,3452,3453,3454,3455,
3456,3457,3458,3459,3460,3461,3462,3463,3464,3465,3466,3467,3468,3469,3470,3471,
3472,3473,3474,3475,3476,3477,3478,3479,3480,3481,3482,3483,3484,3485,3486,3487,
3488,3489,3490,3491,3492,3493,3494,3495,3496,3497,3498,3499,3500,3501,3502,3503,
3504,3505,3506,3507,3508,3509,3510,3511,3512,3513,3514,3515,3516,3517,3518,3519,
3520,3521,3522,3523,3524,3525,3526,3527,3528,3529,3530,3531,3532,3533,3534,3535,
3536,3537,3538,3539,3540,3541,3542,3543,3544,3545,3546,3547,3548,3549,3550,3551,
3552,3553,3554,3555,3556,3557,3558,3559,3560,3561,3562,3563,3564,3565,3566,3567,
3568,3569,3570,3571,3572,3573,3574,3575,3576,3577,3578,3579,3580,3581,3582,3583,
3584,3585,3586,3587,3588,3589,3590,3591,3592,3593,3594,3595,3596,3597,3598,3599,
3600,3601,3602,3603,3604,3605,3606,3607,3608,3609,3610,3611,3612,3613,3614,3615,
3616,3617,3618,3619,3620,3621,3622,3623,3624,3625,3626,3627,3628,3629,3630,3631,
3632,3633,3634,3635,3636,3637,3638,3639,3640,3641,3642,3643,3644,3645,3646,3647,
3648,3649,3650,3651,3652,3653,3654,3655,3656,3657,3658,3659,3660,3661,3662,3663,
3664,3665,3666,3667,3668,3669,3670,3671,3672,3673,3674,3675,3676,3677,3678,3679,
3680,3681,3682,3683,3684,3685,3686,3687,3688,3689,3690,3691,3692,3693,3694,3695,
3696,3697,3698,3699,3700,3701,3702,3703,3704,3705,3706,3707,3708,3709,3710,3711,
3712,3713,3714,3715,3716,3717,3718,3719,3720,3721,3722,3723,3724,3725,3726,3727,
3728,3729,3730,3731,3732,3733,3734,3735,3736,3737,3738,3739,3740,3741,3742,3743,
3744,3745,3746,3747,3748,3749,3750,3751,3752,3753,3754,3755,3756,3757,3758,3759,
3760,3761,3762,3763,3764,3765,3766,3767,3768,3769,3770,3771,3772,3773,3774,3775,
3776,3777,3778,3779,3780,3781,3782,3783,3784,3785,3786,3787,3788,3789,3790,3791,
3792,3793,3794,3795,3796,3797,3798,3799,3800,3801,3802,3803,3804,3805,3806,3807,
3808,3809,3810,3811,3812,3813,3814,3815,3816,3817,3818,3819,3820,3821,3822,3823,
3824,3825,3826,3827,3828,3829,3830,3831,3832,3833,3834,3835,3836,3837,3838,3839,
3840,3841,3842,3843,3844,3845,3846,3847,3848,3849,3850,3851,3852,3853,3854,3855,
3856,3857,3858,3859,3860,3861,3862,3863,3864,3865,3866,3867,3868,3869,3870,3871,
3872,3873,3874,3875,3876,3877,3878,3879,3880,3881,3882,3883,3884,3885,3886,3887,
3888,3889,3890,3891,3892,3893,3894,3895,3896,3897,3898,3899,3900,3901,3902,3903,
3904,3905,3906,3907,3908,3909,3910,3911,3912,3913,3914,3915,3916,3917,3918,3919,
3920,3921,3922,3923,3924,3925,3926,3927,3928,3929,3930,3931,3932,3933,3934,3935,
3936,3937,3938,3939,3940,3941,3942,3943,3944,3945,3946,3947,3948,3949,3950,3951,
3952,3953,3954,3955,3956,3957,3958,3959,3960,3961,3962,3963,3964,3965,3966,3967,
3968,3969,3970,3971,3972,3973,3974,3975,3976,3977,3978,3979,3980,3981,3982,3983,
3984,3985,3986,3987,3988,3989,3990,3991,3992,3993,3994,3995,3996,3997,3998,3999,
4000,4001,4002,4003,4004,4005,4006,4007,4008,4009,4010,4011,4012,4013,4014,4015,
4016,4017,4018,4019,4020,4021,4022,4023,4024,4025,4026,4027,4028,4029,4030,4031,
4032,4033,4034,4035,4036,4037,4038,4039,4040,4041,4042,4043,4044,4045,4046,4047,
4048,4049,4050,4051,4052,4053,4054,4055,4056,4057,4058,4059,4060,4061,4062,4063,
4064,4065,4066,4067,4068,4069,4070,4071,4072,4073,4074,4075,4076,4077,4078,4079,
4080,4081,4082,4083,4084,4085,4086,4087,4088,4089,4090,4091,4092,4093,4094,4095};

static int _milena_wchar(struct milena *cfg,int chr,char *outbuf,int len,int *cap)
{
	char bufline[1024],*cs;
	int is_letter,is_upper;
	int n,litera,slen,dummy;
	struct milena_char *cl;
	if (cap) *cap=0;
	for (cl=cfg->charnms;cl;cl=cl->next) {
		if (cl->chr == chr) {
			//fprintf(stderr,"Found %d\n",chr);
			if (outbuf) {
				strcpy(outbuf,cl->pron);
				return strlen(outbuf)+1;
			}
			else return strlen(cl->pron)+1;
		}
	}
	if (chr >= 0x1000) goto fallback;
	is_letter=letter_flags[chr] & U_LETTER;
	is_upper=letter_flags[chr] & U_UPPER;
	if (cap) {
		*cap=is_upper;
		is_upper=0;
	}
	n=letter_lower[chr];
	if (n) chr=n;
	slen=1;
	bufline[0]=0;
	if (outbuf) *outbuf=0;
	for (cl=cfg->charnms;cl;cl=cl->next) {
		if (cl->chr == chr) {
			//fprintf(stderr,"UFound %d\n",chr);
			if (is_upper) {
				cs=_milena_get_char_desc(cfg,"cap","due");
				if (outbuf) {
					strcat(outbuf,cs);
					strcat(outbuf," ");
				}
				else {
					slen+=strlen(cs)+1;
				}
			}
			if (outbuf) {
				strcat(outbuf,cl->pron);
			}
			else {
				slen+=strlen(cl->pron);
			}
			if (outbuf) return strlen(outbuf)+1;
			return slen;
		}
	}
	
	if (chr>=0x20 && chr<0x7f) {
		if (is_upper) {
			cs=_milena_get_char_desc(cfg,"cap","due");
			if (outbuf) {
				strcat(outbuf,cs);
				strcat(outbuf," ");
			}
			else {
				slen+=strlen(cs)+1;
			}
		}
		cs=_milena_ascii_chars[chr-0x20];
		if (outbuf) {
			strcat(outbuf,"[2]");
			strcat(outbuf,cs);
		}
		else {
			slen+=strlen(cs)+3;
		}
		if (outbuf) return strlen(outbuf)+1;
		return slen;
	}
	if (chr>=0xc0 && chr <MILENA_MAX_CHAR_DEFINED) {
		chr-=0xc0;
		if (char_descr[chr].flags == 1) { /* ligatura */
			if (is_upper) {
				cs=_milena_get_char_desc(cfg,"caplig","wielka ligatura");
			}
			else {
				cs=_milena_get_char_desc(cfg,"lig","ligatura");
			}
			if (outbuf) {
				strcat(outbuf,cs);
				strcat(outbuf," ");
			}
			else {
				slen+=strlen(cs)+1;
			}
			litera=char_descr[chr].letter;
			cs=_milena_ascii_chars[litera-32];
			if (outbuf) {
				strcat(outbuf,"[2]");
				strcat(outbuf,cs);
			}
			else {
				slen+=3+strlen(cs);
			}
			litera=char_descr[chr].second;
			if (litera) {
				cs=_milena_ascii_chars[litera-32];
				if (outbuf) {
					strcat(outbuf," [2]");
					strcat(outbuf,cs);
				}
				else {
					slen+=4+strlen(cs);
				}
			}
			if (outbuf) return strlen(outbuf)+1;
			return slen;
		}
		if (is_upper) {
			cs=_milena_get_char_desc(cfg,"cap","due");
			if (outbuf) {
				strcat(outbuf,cs);
				strcat(outbuf," ");
			}
			else {
				slen+=strlen(cs)+1;
			}
		}
		litera=char_descr[chr].letter;
		cs=_milena_ascii_chars[litera-32];
		if (outbuf) {
			strcat(outbuf,"[2]");
			strcat(outbuf,cs);
		}
		else {
			slen+=3+strlen(cs);
		}
		cs=_milena_get_char_desc(cfg,dia_sym[char_descr[chr].flags-2],NULL);
		if (outbuf) {
			strcat(outbuf," ");
			strcat(outbuf,cs);
		}
		else {
			slen+=strlen(cs)+4;
		}
		if (outbuf) return strlen(outbuf)+1;
		return slen;
	}

fallback:	
	sprintf(bufline,"znak %d",chr);
	cs=bufline;
	return _milena_GetPhraseWithPunct(cfg,&cs,outbuf,len,&dummy,0,NULL);
}

int milena_wchar(struct milena *cfg,int chr,char *outbuf,int len,int *cap)
{
	return _milena_wchar(cfg,chr,outbuf,len,cap);
}

int milena_char(struct milena *cfg,char *chr,char *outbuf,int len,int *cap)
{
	int wc=get_unichar(&chr);
	return _milena_wchar(cfg,wc,outbuf,len,cap);
}

int milena_key(struct milena *cfg,char *key,char *outbuf,int len,int *cap)
{
	struct milena_key *kl;
	char *c;
	int wc,dummy;
	if (cap) *cap=0;
	for (kl=cfg->keys;kl;kl=kl->next) {
		if (!strcmp(kl->key,key)) {
			if (outbuf && len > strlen(kl->pron)) strcpy(outbuf,kl->pron);
			return strlen(kl->pron)+1;
		}
	}
	c=key;
	wc=get_unichar(&c);
	if (!*c) return _milena_wchar(cfg,wc,outbuf,len,cap);
	return _milena_GetPhraseWithPunct(cfg,&key,outbuf,len,&dummy,0,NULL);
}
