/*
 * morfologik_shm.c - fast and simple interface to morfologik
 * Copyright (C) Bohdan R. Rau 2012 <ethanak@polip.com>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with Milena.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <signal.h>
#include "libmorfologik.h"

void free_me(void)
{
    int i,kid;
    for (i=0;i<=5;i++) {
        kid=shmget(MF_SHMAT_MAGIC+i,0,0);
        if (kid >= 0) shmctl(kid,IPC_RMID,NULL);
    }
}

void helpme(char *str,int ex)
{
    fprintf(stderr,"Sposób użycia: %s [-k|-q]\n\
    -q - usuń segmenty pamięci wspólnej i wyjdź\n\
    -k - przeładuj segmenty pamięci wspólnej, czekaj na przerwanie,\n\
         następnie usuń segmenty pamięci wspólnj i wyjdź.\n\
    Bez opcji: przeładowuje segmenty pamięci wspólnej.\n",str);
    exit(ex);
}

void dummy(int d)
{
    return;
}

main(int argc,char *argv[])
{
    int mode=0;
    struct morfologik_data *md;
    if (argc >2) helpme(argv[0],1);
    if (argc ==2) {
        if (!strcmp(argv[1],"-k")) mode=1;
        else if (!strcmp(argv[1],"-q")) mode=2;
        else if (!strcmp(argv[1],"-h")) helpme(argv[0],0);
        else helpme(argv[0],1);
    }
    free_me();
    if (mode == 2) exit(0);
    md=morfologik_CreateShm(NULL);
    if (!md) {
        perror("morfologik_shm");
        exit(1);
    }
    if (mode == 1) {
        signal(SIGINT,dummy);
        pause();
        free_me();
    }
    exit(0);
}