#!/usr/bin/env python
#coding: utf-8

import socket

def _constrain(a,b,c):
    if a < b:
        return b
    elif a > c:
        return c
    return a

    
class Voice(object):
    def __init__(self, host="localhost", port=1314, tempo = None, freq = None,
            samplefreq = None, samplerate = None, voice = None):
        self._host = None
        self._port = None
        self._tempo = None
        self._freq = None
        self._samplerate = None
        self._samplefreq = None
        if voice != None:
            f=None
            try:
                f=open(voice,"r")
            except:
                if '/' not in voice:
                    if not voice.endswith('.voice'):
                        voice += '.voice'
                    try:
                        f=open('/usr/share/kedrigern/' + voice, "r")
                    except:
                        pass
            if not f:
                raise Exception('Brak ' + voice)
            
                    
        if self._host is None:
            self._host = "127.0.0.1" if host == "localhost" else host
        if self._port is None:
            self._port = _constrain(int(port),0,65535)
        if self._tempo is None and tempo is not None:
            self._tempo = _constrain(float(tempo), 0.5, 2.0)
        if self._freq is None and freq is not None:
            self._freq = _constrain(float(freq), 0.5, 2.0)
        if self._samplefreq is None and samplefreq is not None:
            self._samplefreq = _constrain(int(samplefreq), 8000,32000)
        if self._samplerate is None and samplerate is not None:
            self._samplerate = _constrain(int(samplerate), 8000,32000)
    
    def stop(self):
        server_address = (self._host, self._port)
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.connect(server_address)
        sock.sendall(b'stop')
        rc=sock.recv(64)
        sock.close()
        return rc == b'OK'
    
    def say(self,txt,tempo=None, freq=None, samplefreq=None, samplerate=None):
        if tempo is None:
            tempo = self._tempo
        else:
            tempo = _constrain(float(tempo), 0.5, 2.0)
        if freq is None:
            freq = self._freq
        else:
            freq = _constrain(float(freq), 0.5, 2.0)
        if samplefreq is None:
            samplefreq = self._samplefreq
        else:
            samplefreq = _constrain(int(samplefreq), 0.5, 2.0)
        if samplerate is None:
            samplerate = self._samplerate
        else:
            samplerate = _constrain(int(samplerate), 0.5, 2.0)

        sl = ['speak']
        if tempo:
            sl += ['-t', str(tempo)]
        if freq:
            sl += ['-f', str(freq)]
        if samplefreq:
            sl += ['-l', str(samplefreq)]
        if samplerate:
            sl += ['-r', str(samplerate)]
        if txt.startswith('-'):
            sl.append("-- ");
        sl.append(txt)
    
        sl=' '.join(sl)
        server_address = (self._host, self._port)
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.connect(server_address)
        try:
            sock.sendall(sl.encode('utf-8'))
        except:
            sock.sendall(sl)
        rc=sock.recv(64)
        sock.close()
        return rc == b'OK'
    
    def isSpeaking(self):
        server_address = (self._host, self._port)
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.connect(server_address)
        sock.sendall(b'status')
        rc=sock.recv(64)
        sock.close()
        return rc == b'busy'

if __name__ == '__main__':
    v=Voice()
    v.say("Pójdź, kińże tę chmurność w głąb flaszy", freq=0.8)
            
