/* 
 * File:   equalizer.h
 * Author: Marcin Kwiatkowski
 *
 * Created on September 22, 2010, 11:09 AM
 */

#ifndef EQUALISER_H
#define	EQUALISER_H

struct EQSTATE {
    // Filter #1 (Low band)
    double lf; // Frequency
    double f1p0; // Poles ...
    double f1p1;
    double f1p2;
    double f1p3;

    // Filter #2 (High band)

    double hf; // Frequency
    double f2p0; // Poles ...
    double f2p1;
    double f2p2;
    double f2p3;

    // Sample history buffer

    double sdm1; // Sample data minus 1
    double sdm2; //                   2
    double sdm3; //                   3

    // Gain Controls

    double lg; // low  gain
    double mg; // mid  gain
    double hg; // high gain

};

#ifdef __cplusplus
extern "C" {
#endif

void init_equaliser(struct EQSTATE* es, int lowfreq, int highfreq, int mixfreq);
double equalise(struct EQSTATE* es, double sample);
#ifdef __cplusplus
}
#endif

#endif	/* EQUALISER_H */

