#!/usr/bin/env python
#coding: utf-8

import sys,re

_libs=["asound","sndfile"]
_version=None
_pulse=False

if len(sys.argv) > 1 and sys.argv[1] != 'clean':
    
    try:
        f=open('config.h').readlines()
    except:
        print "Please run configure first"
        exit(1)
        
    for a in f:
        r=re.match(r'^#define\s+PACKAGE_VERSION\s+"(.*)"',a.strip())
        if r:
            _version=r.group(1)
            continue
        r=re.match(r'^#define\s+HAVE_PULSE\s+1',a.strip())
        if r:
            _pulse=True
    
    if not _version:
        print "Package not configured"
        sys.exit(1)
    if _pulse:
        _libs.append('pulse-simple')
        
from distutils.core import setup, Extension

module1 = Extension('pyspda',
				libraries=_libs,
				sources=["pyspda.c","sonic.c","equalizer.c"])

setup (name = "PySpda",
	version=_version,
	description="Python Speech-Dispatcher Simple Audio Output",
	ext_modules=[module1])
