#!/bin/bash

bindir=/usr/bin
wine=.winesapi
display=:20
sapi=$(dirname $(readlink -f $0))
#sapi=/usr/lib/sapi4linux

if [ "${UID}" = "0" ] ; then
	echo "This program must be run as regular user, not root!"
	exit 1
fi

# do not change below this line!

milena=true
force=false
center=false

function helpme()
{
	echo "Usage: $0 [-f] [-p] [-a] [bindir]"
	echo "    -f - force (removes all previous ${HOME}/${wine} content)"
	echo "    -p - keep Polish .lex files (incompatible with Milena)"
	echo "    -a - bind server to all interfaces (default localhost)"
	echo "    bindir - binary wine folder (defaults to /usr/local/bin or /usr/bin)"
	echo "Program automatically installs Ivona voices from files or links"
	echo "in ${sapi}/ivona_voices"
	echo "and activates single Ivona voice from key in file"
	echo "${sapi}/ivona_voices/serial.txt"
	echo "Program automatically install infovox3 demo voices"
	echo "from files or links in ${sapi}/infovox_demo"
	exit 1
}

if [ "$1" = "enter" ] ; then
    sleep 1
    export DISPLAY=${display}
	while true; do
		id=`xprop -root |fgrep '_NET_ACTIVE_WINDOW(WINDOW)' | awk '{print $5}' | grep 0x`
		if test "$id" != "" ; then
			if xprop -id $id | grep '^WM_NAME\(STRING\)[= ]+"IVONA ControlCenter"'; then
				xte "keydown Alt_L" "key F4" "keyup Alt_L"
				exit 0
			fi
			#xprop -id $id | grep WM_CLASS
			#if xprop -id $id | egrep '^WM_CLASS.*"\\.dat|Wine"' >/dev/null; then
				xte "key Return"
			#fi
		fi
		sleep 1
	done
fi

bindto="127.0.0.1"

while getopts "hfpca" opt; do
	if [ "$opt" == "f" ] ; then
		force=true
	elif [ "$opt" == "p" ] ; then
		milena=false
	elif [ "$opt" == "c" ] ; then
		center=true
	elif [ "$opt" == "a" ] ; then
		bindto="all"
	else
		helpme
	fi
done
shift $((OPTIND-1))
bindirset="false"
if [ -n "$1" ] ; then
    bindir=$1
    bindirset="true"
    shift 1
fi
[ -e "$@" ]  || helpme

if [ ${bindirset} == "false" ] ; then
    if [ -f /usr/local/bin/wine ] ; then
	bindir=/usr/local/bin
    fi
fi



if [ "${force}" != "true" ] ; then
	if [ -d "$HOME/$wine" ] ; then
		echo "Wine folder ${wine} already exists, use -f to reinstall"
		exit 0
	fi
fi
	
echo Changing current directory to ${sapi}

cd $sapi

function check_prog
{
    if ! which $1 >/dev/null 2>/dev/null; then
        echo "$1 not found, install package $2"
        return 1
    fi
    return 0
}

function open_xvfb
{
    if DISPLAY="$1" xdpyinfo >/dev/null 2>/dev/null ; then
        echo "Screen already exists"
        return
    fi
    nohup Xvfb $1 -screen -0 800x600x16 -nolisten tcp &
    sleep 2
}

function set_winver() {
    echo "Setting Windows version to $1"
    mkdir -p ~/tmp
    cat > ~/tmp/set-winver.reg <<_EOF_
REGEDIT4

[HKEY_CURRENT_USER\Software\Wine]
"Version"="$1"
                  
_EOF_
    ${bindir}/wine regedit ~/tmp/set-winver.reg
}

function unset_winver() {
    echo "Clearing Windows version back to default"
    mkdir -p ~/tmp
    cat > ~/tmp/unset-winver.reg <<_EOF_
REGEDIT4

[HKEY_CURRENT_USER\Software\Wine]
"Version"=-

_EOF_
    ${bindir}/wine regedit ~/tmp/unset-winver.reg
}

function disable_sound()
{
    echo "Disable sound"
    mkdir -p ~/tmp
    cat > ~/tmp/disable-sound.reg <<_EOF_
REGEDIT4

[HKEY_CURRENT_USER\Software\Wine\Drivers]
"Audio"=""

_EOF_
    ${bindir}/wine regedit ~/tmp/disable-sound.reg
}

function enable_sound()
{
	echo "Enable sound"
	${bindir}/wine regedit -D HKEY_CURRENT_USER\\Software\\Wine\\Drivers
}

function install_sapi()
{
	set_winver win2k
	${bindir}/wine msiexec /i `pwd`/data/sapi.msi
	unset_winver
}

bad="false"

check_prog ${bindir}/wine wine
if [ $? == 1 ] ; then bad="true"; fi
check_prog icewm icewm
if [ $? == 1 ] ; then bad="true"; fi
check_prog xte xautomation
if [ $? == 1 ] ; then bad="true"; fi
check_prog xprop x11-utils
if [ $? == 1 ] ; then bad="true"; fi
check_prog Xvfb xvfb
if [ $? == 1 ] ; then bad="true"; fi
check_prog xdpyinfo x11-utils
if [ $? == 1 ] ; then bad = "true"; fi
check_prog nc netcat
if [ $? == 1 ] ; then bad = "true"; fi
if [ "$bad" == "true" ] ; then
    echo "Important programs not found, instalation abandoned"
    exit 1
fi

bash ./srvcreator.sh || exit 1


voices=$(find -L ivona_voices -type f -and -path "*.dat" -and -size +50M)

if [ "$voices]" == "" ] ; then
    echo "No Ivona voices found"
    if [ "${center}" == "true" ] ; then
		echo "Cannot install ControlCenter without voices"
		exit 1
	fi
else
    vcount=0
    for a in $voices; do
        let "vcount=${vcount}+1"
    done
    
    if [ "$vcount" == "0" ] ; then
		echo "No Ivona voices found"
		if [ "${center}" == "true" ] ; then
			echo "Cannot install ControlCenter without voices"
			exit 1
		fi
    elif [ "$vcount" == "1" ] ; then
        echo "One Ivona voice found"
    else
        echo "${vcount} Ivona voices found"
    fi
fi

if [ "${center}" == "true" ] ; then
	if [ ! -f ivona_voices/control.dat ] ; then
		echo "Control center not found"
		exit 1
	fi
fi

idemos=$(find -L infovox_demo -type f -and -path "*.exe" -and -size +50M)
if [ "${idemos}" == "" ] ; then
    echo "No Infovox3 demo voices found"
else
    icount=0
    for a in $idemos; do
        let "icount=${icount}+1"
    done
    if [ "${icount}" == "1" ] ; then
        echo "One Infovox3 demo voice found"
    else
        echo "${idemos} Infovox3 demo voices found"
    fi
fi




open_xvfb ${display}


sleep 3
export DISPLAY=${display}
export WINEPREFIX=$HOME/$wine
export WINEDEBUG=-all
export WINEDLLOVERRIDES=winemenubuilder.exe=d


echo killServer | nc 127.0.0.1 8765 2>/dev/null && sleep 3
if [ -d "$HOME/$wine" ] ; then
	echo "Shutting down wine"
	${bindir}/wineboot -k -s
fi
rm -rf ~/$wine
${bindir}/wineboot -i

icewm >/dev/null 2>/dev/null &
bpid=$!

install_sapi

if [ "${idemos}" != "" ] ; then
    for voice in ${idemos}; do
	echo "Installing ${voice}"
	${bindir}/wine pydir/python.exe ./infovox_install.py ${voice}
    done
    echo rebooting wine
    ${bindir}/wineboot -k -s
    sleep 10
    ${bindir}/wineboot
    sleep 10
fi


if [ "${voices}" != "" ] ; then
    /bin/bash $0 enter >/dev/null 2>/dev/null &
    apid=$!

    disable_sound
    for voice in ${voices}; do
		echo "Installing ${voice}"
        ${bindir}/wine ${voice}
    done
    if [ "${center}" == "true" ] ; then
		echo "Installing Control Center"
		${bindir}/wine ivona_voices/control.dat
	fi

    kill $apid

    echo Ivona voices installed, reinstalling sapi
    cd $sapi
    install_sapi

	if [ "${milena}" == "true" ] ; then
		ivodir="${WINEPREFIX}/drive_c/Program Files/IVONA/IVONA 2 Voice"
	    if [ -f "${ivodir}/polish-ivona.lex" ] ; then
			echo "Removing Polish Ivona lex files"
			mv "${ivodir}/polish-ivona.lex" "${ivodir}/polish-ivona.lex.orig"
			cp data/polish-ivona.lex "${ivodir}/polish-ivona.lex"
		fi
		if [ -f "${ivodir}/polish-prm.lex" ] ; then
			mv "${ivodir}/polish-prm.lex" "${ivodir}/polish-prm.lex.orig"
		fi
    fi
    if [ -f "ivona_voices/serial.txt" ] ; then
		#key=$(awk --posix '/^([0-9A-Z]{5}-){5}[0-9A-Z]{5}$/ {a=tolower($1);gsub("-","",a);print a}' ivona_voices/serial.txt)
		key=$(python -c '
import re
t=re.search(r"^\s*(([0-9A-Z]{5}-){5}[0-9A-Z]{5})\s*$",open("ivona_voices/serial.txt").read(),re.DOTALL | re.M)
if t:
    print t.group(1)
')

		if [ "${key}" == "" ] ; then
			echo "Ivona key not found in serial.txt"
		else
			mkdir -p ~/tmp
			cat >~/tmp/register_ivona.reg <<EOF
REGEDIT4

[HKEY_LOCAL_MACHINE\Software\IVONA\SerialNumbers\1]
@="$key"
EOF

			echo "Activating Ivona voice"
			${bindir}/wine regedit ~/tmp/register_ivona.reg
		fi
	fi

	#wine ivona_voices/control.dat
	enable_sound

fi


echo Creating server wrapper command in ~/bin/sapi_server.sh
mkdir -p ~/bin
if [ ${bindto} == "all" ] ; then
    deflisten="all interfaces"
else
    deflisten="localhost only"
fi

winereboot=""
if [ "${idemos}" != "" ] ; then
    winereboot='if [ "$1" != "noboot" ] ; then ${bindir}/wineboot -k -s;sleep 8;${bindir}/wineboot;sleep 8;fi'
fi

cat > ~/bin/sapi_server.sh << END
#!/bin/bash

# Do not edit this file - it will be overwritten
# by server installer!

if [ "\$1" == "help" ] || [ "\$1" == "-h" ] ; then
    echo "Usage: \$0 [stop|local|all|help]"
    echo "  stop  - stop running server and exit"
    echo "  local - start server listening on localhost only"
    echo "  all   - start server listening on all interfaces"
    echo
    echo "  default is restart or start server listening on default address"
    echo "  (currently ${deflisten})"
    exit 0
fi
echo killServer | nc 127.0.0.1 8765 2>/dev/null && sleep 3
if [ "\$1" == "stop" ] ; then
    exit 0
fi
export WINEPREFIX=${WINEPREFIX}
export WINEDEBUG=-all
export DISPLAY=${display}
ADDR=${bindto}
if [ "\$1" == "local" ] ; then
    ADDR=127.0.0.1
elif [ "\$1" == "all" ] ; then
    ADDR=all
fi
if ! xdpyinfo >/dev/null 2>/dev/null ; then
    nohup Xvfb \${DISPLAY} -screen -0 800x600x16 -nolisten tcp &
    sleep 2
fi
cd ${sapi}
${winereboot}
nohup ${bindir}/wine \
    pydir/python.exe \
    ssapi.py -a \${ADDR} >/dev/null 2>/dev/null &
END
chmod 755 ~/bin/sapi_server.sh
echo Creating Ivona voice download command in ~/bin/ivona_download.sh
cat > ~/bin/ivona_download.sh << END
#!/bin/bash

# Do not edit this file - it will be overwritten
# by server installer!

export WINEPREFIX=${WINEPREFIX}
export WINEDEBUG=-all
export DISPLAY=${display}
if ! xdpyinfo >/dev/null 2>/dev/null ; then
    nohup Xvfb \${DISPLAY} -screen -0 800x600x16 -nolisten tcp &
    sleep 2
fi

${bindir}/wine explorer /desktop=ividn,800x600 ${sapi}/pydir/python.exe ${sapi}/ivodownload.py \$@

END
chmod 755 ~/bin/ivona_download.sh
echo Running server
~/bin/sapi_server.sh noboot
kill $bpid
